<?php
include 'admin/include/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'];

    if ($action === 'load') {
        // Load all blogs
        $sql = "SELECT * FROM blog WHERE status=1 ORDER BY date DESC";
        $res = mysqli_query($conn, $sql);
        $count = mysqli_num_rows($res);

        $html = '';
        while ($row = mysqli_fetch_assoc($res)) {
            $html .= '
            <div class="item">
                <div class="post-thumb">
                    <a href="' . $row['url'] . '">
                        <img src="admin/uploads/' . $row['image'] . '" alt="' . htmlspecialchars($row['heading']) . '" style="width:70px;height:70px;">
                    </a>
                </div>
                <a href="' . $row['url'] . '">
                    <h4>' . htmlspecialchars($row['heading']) . '</h4>
                </a>
                <div class="post-info">' . date("F d, Y", strtotime($row['date'])) . '</div>
            </div>';
        }

        echo json_encode(['count' => $count, 'html' => $html]);
    }

    if ($action === 'search') {
        $keyword = mysqli_real_escape_string($conn, $_POST['keyword']);
        $sql = "SELECT * FROM blog 
                WHERE status=1 AND (heading LIKE '%$keyword%' OR description LIKE '%$keyword%')
                ORDER BY date DESC";
        $res = mysqli_query($conn, $sql);

        if (mysqli_num_rows($res) > 0) {
            while ($row = mysqli_fetch_assoc($res)) {
                echo '
                <div class="item">
                    <a href="' . $row['url'] . '">
                        <h5>' . htmlspecialchars($row['heading']) . '</h5>
                    </a>
                    <div class="post-info">' . date("F d, Y", strtotime($row['date'])) . '</div>
                </div>';
            }
        } else {
            echo "<p>No results found.</p>";
        }
    }
}
?>