<?php
require('../include/function.inc.php');
include '../include/header.php';

// Handle status change
if (isset($_GET['type']) && $_GET['type'] === 'status' && isset($_GET['operation']) && isset($_GET['id'])) {
    $operation = $_GET['operation'];
    $id = intval($_GET['id']);
    $status = ($operation === 'active') ? 1 : 0;
    mysqli_query($conn, "UPDATE sub_categories SET status = '$status' WHERE id = '$id'");
}

// Handle deletion
if (isset($_GET['type']) && $_GET['type'] === 'delete' && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    mysqli_query($conn, "DELETE FROM sub_categories WHERE id = '$id'");
}

// Fetch subcategories with category name
$sql = "SELECT sub_categories.*, categories.categories 
        FROM sub_categories 
        INNER JOIN categories ON sub_categories.cat_name = categories.id 
        ORDER BY sub_categories.id DESC";

$result = mysqli_query($conn, $sql);

include '../include/side_bar.php';
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3>All Sub Categories</h3>
            <div class="dashboard_heading__right">
                <a href="/">Home</a> <span>/</span>
                <p>Sub Categories</p>
            </div>
        </div>

        <div class="salary_wrapper">
            <div class="salary_header">
                <h5>Sub Categories</h5>
                <div class="salary_header__right">
                    <a href="add-sub-categories.php"><i class="fa-solid fa-plus"></i> Add Sub Category</a>
                </div>
            </div>

            <div class="salary-table">
                <div class="salary-box">
                    <table class="table table-striped" id="tableall">
                        <thead>
                            <tr class="table-head">
                                <th>#</th>
                                <th>Category Name</th>
                                <th>Sub Category Name</th>
                                <th>Status</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $i = 1;
                            while ($row = mysqli_fetch_assoc($result)) { ?>
                                <tr>
                                    <td><?php echo $i++; ?></td>
                                    <td><?php echo htmlspecialchars($row['categories']); ?></td>
                                    <td><?php echo htmlspecialchars($row['sub_name']); ?></td>
                                    <td>
                                        <?php if ($row['status'] == 1) { ?>
                                            <span class='btn btn-warning'>
                                                <a style='color:#fff;'
                                                    href='?type=status&operation=inactive&id=<?php echo $row['id']; ?>'>Deactivate</a>
                                            </span>
                                        <?php } else { ?>
                                            <span class='btn btn-success'>
                                                <a style='color:#fff;'
                                                    href='?type=status&operation=active&id=<?php echo $row['id']; ?>'>Activate</a>
                                            </span>
                                        <?php } ?>
                                    </td>
                                    <td><?php echo date("d-m-Y", strtotime($row['created_at'])); ?></td>
                                    <td>
                                        <a href="add-sub-categories.php?id=<?php echo $row['id']; ?>"
                                            class="btn btn-sm btn-primary">Edit</a>
                                        <a href="?type=delete&id=<?php echo $row['id']; ?>" class="btn btn-sm btn-danger"
                                            onClick="return confirm('Are you sure?');">Delete</a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include '../include/footer.php'; ?>