<?php
include '../include/header.php';
include '../include/side_bar.php';
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3>View Packages</h3>
            <div class="dashboard_heading__right">
                <a href="/">Home</a> <span>/</span>
                <p>Packages</p>
            </div>
        </div>

        <div class="content_wrapper">
            <div class="salary_header">
                <h5>Services List</h5>
                <div class="salary_header__right">
                    <a href="add-services.php"><i class="fa-solid fa-plus"></i> Add Packages</a>
                </div>
            </div>

            <div class="content-table">
                <div class="table-box">
                    <div class="table-responsive">
                        <table class="table table-striped" id="tableall">
                            <thead>
                                <tr class="table-head">
                                    <th>S.NO</th>
                                    <th>Category Name</th>
                                    <th>Sub Category Name</th>
                                    <th>Service Heading</th>
                                    <th>Service Description</th>
                                    <th>Service Image</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                // Delete
                                
                                if (isset($_GET['type']) && $_GET['type'] === 'status' && isset($_GET['operation']) && isset($_GET['id'])) {
                                    $operation = $_GET['operation'];
                                    $id = intval($_GET['id']);
                                    $status = ($operation === 'active') ? 1 : 0;
                                    mysqli_query($conn, "UPDATE services SET status = '$status' WHERE id = '$id'");
                                }

                                if (isset($_GET['type']) && $_GET['type'] == 'delete') {
                                    $id = intval($_GET['id']);
                                    $res = mysqli_query($conn, "SELECT image FROM services WHERE id='$id'");
                                    $imgData = mysqli_fetch_assoc($res);
                                    if (!empty($imgData['image'])) {
                                        unlink('../uploads/' . $imgData['image']);
                                    }
                                    mysqli_query($conn, "DELETE FROM services WHERE id='$id'");
                                }

                                // Join query: services -> sub_categories -> categories
                                
                                $sql = "
                                    SELECT s.*, 
                                           sub.sub_name AS subcategory_name,
                                           c.categories AS category_name
                                    FROM services s
                                    INNER JOIN sub_categories sub ON s.sub_cate = sub.id
                                    INNER JOIN categories c ON sub.cat_name = c.id
                                    ORDER BY s.id DESC
                                ";

                                // $sql = "SELECT * FROM servic";
                                
                                $result = mysqli_query($conn, $sql);
                                $sno = 0;
                                $total_entries = mysqli_num_rows($result);

                                while ($row = mysqli_fetch_assoc($result)) {
                                    $sno++;
                                    ?>
                                    <tr>
                                        <td><?php echo $sno; ?></td>
                                        <td><?php echo htmlspecialchars($row['category_name']); ?></td>
                                        <td><?php echo htmlspecialchars($row['subcategory_name']); ?></td>
                                        <td><?php echo htmlspecialchars(substr($row['heading'], 0, 30)); ?></td>
                                        <td><?php echo htmlspecialchars(substr($row['description'], 0, 50)); ?></td>
                                        <td>
                                            <?php if (!empty($row['image'])): ?>
                                                <img src="../uploads/<?php echo $row['image']; ?>" width="80" height="60">
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($row['status'] == 1) { ?>
                                                <span class='btn btn-warning'>
                                                    <a style='color:#fff;'
                                                        href='?type=status&operation=inactive&id=<?php echo $row['id']; ?>'>Deactivate</a>
                                                </span>
                                            <?php } else { ?>
                                                <span class='btn btn-success'>
                                                    <a style='color:#fff;'
                                                        href='?type=status&operation=active&id=<?php echo $row['id']; ?>'>Activate</a>
                                                </span>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <a href="add-services.php?id=<?php echo $row['id']; ?>"
                                                class="btn btn-sm btn-primary">Edit</a>
                                            <a href="?type=delete&id=<?php echo $row['id']; ?>"
                                                class="btn btn-sm btn-danger"
                                                onclick="return confirm('Are you sure to delete?');">Delete</a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="table-box-bottom">
                        <p>Showing 1 to <?php echo $sno; ?> of <?php echo $total_entries; ?> entries</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include '../include/footer.php'; ?>

<style>
    .table-responsive {
        width: 100%;
        overflow-x: auto;
        white-space: nowrap;
    }

    .table {
        min-width: 1300px;
        border-collapse: collapse;
    }

    .table th,
    .table td {
        padding: 10px;
        text-align: left;
        border: 1px solid #ddd;
    }

    .table-box {
        padding: 10px;
        background: #fff;
        border-radius: 5px;
    }
</style>