<?php
require('../include/function.inc.php');
include '../include/header.php';

$id = '';
$image = '';
$name = '';
$description = '';

if (isset($_GET['id']) && $_GET['id'] > 0) {
    $id = intval($_GET['id']);
    $row = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM strength WHERE id='$id'"));
    $image = $row['image'];
    $name = $row['name'];
    $description = $row['description'];
}

// Insert / Update Logic
if (isset($_POST['submit'])) {
    foreach ($_FILES['image']['tmp_name'] as $key => $tmp_name) {
        $name_field = mysqli_real_escape_string($conn, $_POST['name'][$key]);
        $desc_field = mysqli_real_escape_string($conn, $_POST['description'][$key]);

        if (!empty($tmp_name)) {
            $file_name = uniqid() . '_' . $_FILES['image']['name'][$key];
            move_uploaded_file($tmp_name, "../uploads/" . $file_name);

            mysqli_query($conn, "INSERT INTO strength (image, name, description, status) VALUES ('$file_name', '$name_field', '$desc_field', 1)");
        }
    }
    header('Location: view-strength.php');
    exit();
}

include '../include/side_bar.php';
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h3 class="mb-0">Add Strength Entries</h3>
            <a href="strength-list.php" class="btn btn-secondary">Back</a>
        </div>

        <form method="post" enctype="multipart/form-data">
            <div id="strength_wrapper" class="row g-3">
                <div class="strength_item col-12 p-4 border rounded bg-light position-relative">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">Image</label>
                            <input type="file" name="image[]" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Name</label>
                            <input type="text" name="name[]" class="form-control" placeholder="Enter Name" required>
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">Description</label>
                            <textarea name="description[]" class="form-control" placeholder="Enter Description" rows="2"
                                required></textarea>
                        </div>
                    </div>
                    <button type="button"
                        class="btn btn-danger btn-sm position-absolute top-0 end-0 m-2 remove-btn">Remove</button>
                </div>
            </div>

            <div class="d-flex gap-2 mt-4">
                <button type="button" id="add-more" class="btn btn-primary">Add More</button>
                <button type="submit" name="submit" class="btn btn-success">Submit</button>
            </div>
        </form>

    </div>
</main>

<script>
    document.getElementById('add-more').addEventListener('click', function () {
        var wrapper = document.getElementById('strength_wrapper');
        var html = `
        <div class="strength_item col-12 p-4 border rounded bg-light position-relative mt-3">
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Image</label>
                    <input type="file" name="image[]" class="form-control" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Name</label>
                    <input type="text" name="name[]" class="form-control" placeholder="Enter Name" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Description</label>
                    <textarea name="description[]" class="form-control" placeholder="Enter Description" rows="2" required></textarea>
                </div>
            </div>
            <button type="button" class="btn btn-danger btn-sm position-absolute top-0 end-0 m-2 remove-btn">Remove</button>
        </div>
        `;
        wrapper.insertAdjacentHTML('beforeend', html);
    });

    document.addEventListener('click', function (e) {
        if (e.target && e.target.classList.contains('remove-btn')) {
            e.target.closest('.strength_item').remove();
        }
    });
</script>

<?php include '../include/footer.php'; ?>