<?php
require('../include/function.inc.php');
include '../include/header.php';

// Status Update Logic
if (isset($_GET['type']) && $_GET['type'] == 'status' && isset($_GET['operation']) && isset($_GET['id'])) {
    $operation = $_GET['operation'];
    $id = intval($_GET['id']);
    $status = ($operation == 'active') ? 1 : 0;
    $update_status_sql = "UPDATE product SET status = '$status' WHERE id = '$id'";
    mysqli_query($conn, $update_status_sql);
}

// Delete Logic with Image File Removal
if (isset($_GET['type']) && $_GET['type'] == 'delete' && isset($_GET['id'])) {
    $id = intval($_GET['id']);

    // Get image name
    $get_img_sql = "SELECT image FROM product WHERE id = '$id'";
    $img_result = mysqli_query($conn, $get_img_sql);
    if ($img_result && mysqli_num_rows($img_result) > 0) {
        $img_row = mysqli_fetch_assoc($img_result);
        $image_path = '../uploads/' . $img_row['image'];
        if (file_exists($image_path)) {
            unlink($image_path);
        }
    }

    // Delete product
    $delete_sql = "DELETE FROM product WHERE id='$id'";
    mysqli_query($conn, $delete_sql);
}

// Fetch all products with categories
$sql = "SELECT product.*, categories.categories 
        FROM product 
        JOIN categories ON product.categories_id = categories.id 
        ORDER BY product.id DESC";
$result = mysqli_query($conn, $sql);
?>

<?php include '../include/side_bar.php'; ?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3>All Products</h3>
            <div class="dashboard_heading__right">
                <a href="/">Home</a> <span>/</span>
            </div>
        </div>

        <div class="salary_wrapper">
            <div class="salary_header">
                <h5>Product</h5>
                <div class="salary_header__right">
                    <a href="add-product.php"><i class="fa-solid fa-plus"></i> Add Product</a>
                </div>
            </div>

            <div class="salary-table">
                <div class="salary-box">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr class="table-head">
                                    <th>#</th>
                                    <th>ID</th>
                                    <th>Category</th>
                                    <th>Product Name</th>
                                    <th>Author</th>
                                    <th>Released</th>
                                    <th>MRP</th>
                                    <th>Price</th>
                                    <th>Qty</th>
                                    <th>Brand</th>
                                    <th>Offer</th>
                                    <th>Image</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                while ($row = mysqli_fetch_assoc($result)) {
                                    ?>
                                    <tr>
                                        <td><?php echo $i++; ?></td>
                                        <td><?php echo $row['id']; ?></td>
                                        <td><?php echo $row['categories']; ?></td>
                                        <td><?php echo $row['name']; ?></td>
                                        <td><?php echo $row['author']; ?></td>
                                        <td><?php echo $row['released']; ?></td>
                                        <td><?php echo $row['mrp']; ?></td>
                                        <td><?php echo $row['price']; ?></td>
                                        <td><?php echo $row['qty']; ?></td>
                                        <td><?php echo $row['brands']; ?></td>
                                        <td><?php echo $row['offer']; ?></td>
                                        <td>
                                            <?php if (!empty($row['image'])) { ?>
                                                <img src="../uploads/<?php echo $row['image']; ?>" width="50" height="50" />
                                            <?php } ?>
                                        </td>

                                        <td>
                                            <?php if ($row['status'] == 'Active') {
                                                echo "<span class='btn btn-round btn-warning'><a style='color:#fff;' href='?type=status&operation=inactive&id=" . $row['id'] . "'>Deactivate</a></span>";
                                            } else {
                                                echo "<span class='btn btn-round btn-success'><a style='color:#fff;' href='?type=status&operation=active&id=" . $row['id'] . "'>Activate</a></span>";
                                            } ?>
                                        </td>
                                        <td>
                                            <a href="add-product.php?id=<?php echo $row['id']; ?>" class="edit">Edit</a> |
                                            <a href="?type=delete&id=<?php echo $row['id']; ?>" class="delete"
                                                onClick="return confirm('Please confirm deletion.');">Delete</a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="salary-box-bottom">
                        <p>Showing <?php echo mysqli_num_rows($result); ?> entries</p>
                        <div class="next-prev">
                            <button>Previous</button>
                            <p>1</p>
                            <button>Next</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include '../include/footer.php'; ?>

<style>
    .table-responsive {
        width: 100%;
        overflow-x: auto;
        white-space: nowrap;
    }

    .table {
        min-width: 1800px;
        border-collapse: collapse;
    }

    .table th,
    .table td {
        padding: 10px;
        text-align: left;
        border: 1px solid #ddd;
        vertical-align: top;
    }

    .edit,
    .delete {
        color: #007bff;
        cursor: pointer;
        text-decoration: none;
    }

    .delete {
        color: red;
    }

    .btn-round {
        border-radius: 20px;
        padding: 5px 10px;
        font-size: 12px;
    }
</style>