<?php
include '../include/config.php';
$username = '';
$error = '';
$success = '';
$show_password_form = false;
$redirect = false;

// Process form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['check_username'])) {
        // First form submitted - check username
        $username = trim($_POST['username']);

        if (empty($username)) {
            $error = "Please enter your username";
        } else {
            // Check if username exists
            $stmt = $conn->prepare("SELECT id FROM admin_user WHERE username = ?");
            $stmt->bind_param("s", $username);
            $stmt->execute();
            $stmt->store_result();

            if ($stmt->num_rows > 0) {
                $show_password_form = true;
            } else {
                $error = "Username not found";
            }
            $stmt->close();
        }
    } elseif (isset($_POST['update_password'])) {
        // Second form submitted - update password
        $username = trim($_POST['username']);
        $password = trim($_POST['password']);
        $confirm_password = trim($_POST['confirm_password']);

        if (empty($password) || empty($confirm_password)) {
            $error = "Please fill in all password fields";
        } elseif ($password !== $confirm_password) {
            $error = "Passwords do not match";
        } else {
            // Hash the new password
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);

            // Update password in database
            $stmt = $conn->prepare("UPDATE admin_user SET password = ? WHERE username = ?");
            $stmt->bind_param("ss", $hashed_password, $username);

            if ($stmt->execute()) {
                $success = "Password updated successfully! You will be redirected to login page in 5 seconds...";
                $show_password_form = false;
                $username = '';
                $redirect = true; // Set redirect flag
            } else {
                $error = "Error updating password: " . $con->error;
            }
            $stmt->close();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Recovery</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 500px;
            margin: 0 auto;
            padding: 20px;
        }

        .form-container {
            background: #f9f9f9;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .form-group {
            margin-bottom: 15px;
        }

        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }

        input[type="text"],
        input[type="password"] {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }

        button {
            background: #4CAF50;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        button:hover {
            background: #45a049;
        }

        .error {
            color: red;
            margin-bottom: 15px;
        }

        .success {
            color: green;
            margin-bottom: 15px;
        }
    </style>
</head>

<body>
    <div class="form-container">
        <h1>Password Recovery</h1>

        <?php if (!empty($error)): ?>
            <div class="error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <?php if (!empty($success)): ?>
            <div class="success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>

        <?php if (!$show_password_form && !$redirect): ?>
            <!-- First form: Check username -->
            <form method="post">
                <div class="form-group">
                    <label for="username">Enter your username:</label>
                    <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($username); ?>"
                        required>
                </div>
                <button type="submit" name="check_username">Continue</button>
            </form>
        <?php elseif ($show_password_form && !$redirect): ?>
            <!-- Second form: Update password -->
            <form method="post">
                <input type="hidden" name="username" value="<?php echo htmlspecialchars($username); ?>">

                <div class="form-group">
                    <label for="password">New Password:</label>
                    <input type="password" id="password" name="password" required>
                </div>

                <div class="form-group">
                    <label for="confirm_password">Confirm New Password:</label>
                    <input type="password" id="confirm_password" name="confirm_password" required>
                </div>

                <button type="submit" name="update_password">Update Password</button>
            </form>
        <?php endif; ?>

        <?php if ($redirect): ?>
            <!-- JavaScript for redirect -->
            <script>
                setTimeout(function () {
                    window.location.href = "../index.php";
                }, 5000); // 5000 milliseconds = 5 seconds
            </script>
        <?php endif; ?>
    </div>
</body>

</html>