<?php
include '../include/header.php';
include '../include/side_bar.php';

$id = "";
$name = "";
$city = "";
$description = "";

// Check if ID is provided for update
if (isset($_GET['id'])) {
    $id = $_GET['id'];
    $sql = "SELECT * FROM `testimonial` WHERE id = '$id'";
    $result = mysqli_query($conn, $sql);
    if ($row = mysqli_fetch_assoc($result)) {
        $name = $row['name'];
        $city = $row['city'];
        $description = $row['description'];
    }
}

// Handle Insert / Update
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['submit'])) {
    $id = $_POST['id'] ?? "";
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $city = mysqli_real_escape_string($conn, $_POST['city']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);

    // Update or Insert Query
    if ($id) {
        $sql = "UPDATE `testimonial` SET `name`='$name', `city`='$city', `description`='$description' WHERE `id`='$id'";
        $msg = "Updated";
    } else {
        $sql = "INSERT INTO `testimonial` (`name`, `city`, `description`) VALUES ('$name', '$city', '$description')";
        $msg = "Inserted";
    }

    if (mysqli_query($conn, $sql)) {
        echo "<script>alert('Record $msg successfully!'); window.location.href = 'view-testimonial.php'; </script>";
    } else {
        echo "<script>alert('Error: " . mysqli_error($conn) . "');</script>";
    }
}
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3><?php echo $id ? 'Edit' : 'Add'; ?> Testimonial</h3>
            <div class="dashboard_heading__right">
                <a href="/">Home</a> <span>/</span>
                <p>Testimonial</p>
            </div>
        </div>

        <div class="about_wrapper">
            <form action="#" method="post">
                <input type="hidden" name="id" value="<?php echo htmlspecialchars($id); ?>">

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="name" class="form-label">Name</label>
                            <input type="text" class="form-control" name="name"
                                value="<?php echo htmlspecialchars($name); ?>" required>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="city" class="form-label">City</label>
                            <input type="text" class="form-control" name="city"
                                value="<?php echo htmlspecialchars($city); ?>" required>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control" name="description" rows="5"
                                required><?php echo htmlspecialchars($description); ?></textarea>
                        </div>
                    </div>
                </div>

                <button type="submit" name="submit"
                    class="btn btn-primary"><?php echo $id ? 'Update' : 'Submit'; ?></button>
            </form>
        </div>
    </div>
</main>

<?php include '../include/footer.php'; ?>