<?php
include '../include/header.php';
include '../include/side_bar.php';

$id = "";
$cat_name = "";
$sub_cate = "";
$heading = "";
$description = "";
$image = "";

// Edit case
if (isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $sql = "SELECT * FROM services WHERE id = '$id'";
    $result = mysqli_query($conn, $sql);
    $res_data = mysqli_fetch_assoc($result);
    echo $sub_id = $res_data['sub_cate'];
    $heading = $res_data['heading'];
    $description = $res_data['description'];
    $image = $res_data['image'];
    // echo $sub_id;
    // exit;


    $cat_sql = "SELECT * FROM sub_categories WHERE id = '$sub_id'";
    $res = mysqli_query($conn, $cat_sql);

    if ($res && mysqli_num_rows($res) > 0) {
        $row = mysqli_fetch_assoc($res);
        $cat_id = $row['cat_name'];
    } else {
        echo "No sub-category found.";
        exit;
    }
}

// Form Submit
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['submit'])) {
    $id = $_POST['id'] ?? "";
    $cat_name = mysqli_real_escape_string($conn, $_POST['cat_name']);
    $sub_cate = mysqli_real_escape_string($conn, $_POST['sub_cate']);
    $heading = mysqli_real_escape_string($conn, $_POST['heading']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);

    // Image Upload
    if (!empty($_FILES['image']['name'])) {
        $image = time() . "_" . basename($_FILES['image']['name']);
        move_uploaded_file($_FILES['image']['tmp_name'], "../uploads/" . $image);
    } elseif ($id) {
        $res = mysqli_query($conn, "SELECT image FROM services WHERE id='$id'");
        $row = mysqli_fetch_assoc($res);
        $image = $row['image'];
    }

    if ($id) {
        // Update
        $sql = "UPDATE services SET 
                    -- cat_name='$cat_name',
                    sub_cate='$sub_cate',
                    heading='$heading',
                    description='$description',
                    image='$image'
                   WHERE id='$id'";
    } else {
        // Insert
        $sql = "INSERT INTO services 
                ( sub_cate, heading, description, image)
                VALUES 
                ( '$sub_cate', '$heading', '$description', '$image')";
    }

    if (mysqli_query($conn, $sql)) {
        echo "<script>alert('Record saved successfully!'); window.location.href = 'view-services.php';</script>";
    } else {
        echo "<script>alert('Error: " . mysqli_error($conn) . "');</script>";
    }
}
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3><?php echo $id ? 'Edit' : 'Add'; ?> Service</h3>
        </div>

        <div class="form_wrapper">
            <form action="#" method="post" enctype="multipart/form-data">
                <input type="hidden" name="id" value="<?php echo $id; ?>">

                <div class="row">
                    <!-- Category -->
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Category</label>
                            <select name="cat_name" id="cat_name" class="form-control" required>
                                <option value="">Select Category</option>
                                <?php
                                $res = mysqli_query($conn, "SELECT * FROM categories");

                                while ($row = mysqli_fetch_assoc($res)) {
                                    $selected = ($cat_id == $row['id'] ? 'selected' : '');
                                    echo "<option value='{$row['id']}' $selected>{$row['categories']}</option>";
                                }
                                ?>
                            </select>

                        </div>
                    </div>

                    <!-- Sub Category -->
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Sub Category</label>
                            <select name="sub_cate" id="sub_cate" class="form-control" required>
                                <option value="">Select Sub Category</option>
                                <?php
                                if ($cat_id) {
                                    $sub_q = mysqli_query($conn, "SELECT * FROM sub_categories WHERE cat_name='$cat_id'");
                                    while ($srow = mysqli_fetch_assoc($sub_q)) {
                                        $sel = ($sub_id == $srow['id']) ? 'selected' : '';
                                        echo "<option value='{$srow['id']}' $sel>{$srow['sub_name']}</option>";
                                    }
                                }

                                ?>
                            </select>
                        </div>
                    </div>

                    <!-- Heading -->
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Heading</label>
                            <input type="text" class="form-control" name="heading" value="<?php echo $heading; ?>"
                                required>
                        </div>
                    </div>

                    <!-- Image -->
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Image</label>
                            <input type="file" class="form-control" name="image">
                            <?php if ($image): ?>
                                <img src="../uploads/<?php echo $image; ?>" width="100" class="mt-2">
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Description -->
                    <div class="col-md-12">
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description"
                                required><?php echo $description; ?></textarea>
                        </div>
                    </div>


                </div>

                <button type="submit" name="submit"
                    class="btn btn-primary"><?php echo $id ? 'Update' : 'Submit'; ?></button>
            </form>
        </div>
    </div>
</main>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $('#cat_name').on('change', function () {
        var cat_id = $(this).val();
        if (cat_id) {
            $.ajax({
                url: 'get-subcategories.php',
                type: 'POST',
                data: { cat_id: cat_id },
                success: function (data) {
                    $('#sub_cate').html(data);
                }
            });
        } else {
            $('#sub_cate').html('<option value="">Select Sub Category</option>');
        }
    });
</script>

<?php include '../include/footer.php'; ?>