<?php
include '../include/header.php';
include '../include/side_bar.php';

$id = "";
$hiring = "";
$title = "";
$short_desc = "";
$description = "";
$experience = "";
$profile = "";
$url = "";

// Fetch existing record if editing
if (isset($_GET['id'])) {
    $id = $_GET['id'];
    $query = mysqli_query($conn, "SELECT * FROM job WHERE id = '$id'");
    if ($row = mysqli_fetch_assoc($query)) {
        $hiring = $row['hiring'];
        $title = $row['title'];
        $short_desc = $row['short_desc'];
        $description = $row['description'];
        $experience = $row['experience'];
        $profile = $row['profile'];
        $url = $row['url'];
    }
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? '';
    $hiring = mysqli_real_escape_string($conn, $_POST['hiring']);
    $title = mysqli_real_escape_string($conn, $_POST['title']);
    $short_desc = mysqli_real_escape_string($conn, $_POST['short_desc']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);
    $experience = mysqli_real_escape_string($conn, $_POST['experience']);
    $profile = mysqli_real_escape_string($conn, $_POST['profile']);

    // Generate URL from title (no slash)
    $url = strtolower(trim(preg_replace('/[^a-zA-Z0-9-]+/', '-', $title), '-'));

    if ($id) {
        $sql = "UPDATE job SET 
                    hiring='$hiring',
                    title='$title',
                    short_desc='$short_desc',
                    description='$description',
                    experience='$experience',
                    profile='$profile',
                    url='$url'
                WHERE id='$id'";
        $msg = "Updated";
    } else {
        $sql = "INSERT INTO job (
                    hiring, title, short_desc, description, experience, profile, url
                ) VALUES (
                    '$hiring', '$title', '$short_desc', '$description', '$experience', '$profile', '$url'
                )";
        $msg = "Inserted";
    }

    if (mysqli_query($conn, $sql)) {
        echo "<script>alert('Record $msg successfully!'); window.location.href='view-job.php';</script>";
    } else {
        echo "<script>alert('Error: " . mysqli_error($conn) . "');</script>";
    }
}
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3><?php echo $id ? "Edit" : "Add"; ?> Job</h3>
            <div class="dashboard_heading__right">
                <a href="/">Home</a> <span>/</span>
                <p>Job</p>
            </div>
        </div>

        <div class="banner_wrapper">
            <form method="post">
                <input type="hidden" name="id" value="<?php echo htmlspecialchars($id); ?>">

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label>Hiring</label>
                            <input type="text" class="form-control" name="hiring"
                                value="<?php echo htmlspecialchars($hiring); ?>">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label>Title</label>
                            <input type="text" class="form-control" name="title"
                                value="<?php echo htmlspecialchars($title); ?>" required>
                        </div>
                    </div>


                    <div class="col-md-6">
                        <div class="mb-3">
                            <label>Experience</label>
                            <input type="text" class="form-control" name="experience"
                                value="<?php echo htmlspecialchars($experience); ?>">
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="mb-3">
                            <label>Profile</label>
                            <!-- <textarea class="form-control" name="profile"><?php echo htmlspecialchars($profile); ?></textarea> -->
                            <input type="text" class="form-control" name="profile"
                                value="<?php echo htmlspecialchars($profile); ?>">
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="mb-3">
                            <label>Short Description</label>
                            <textarea class="form-control"
                                name="short_desc"><?php echo htmlspecialchars($short_desc); ?></textarea>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label>Description</label>
                            <textarea class="form-control"
                                name="description"><?php echo htmlspecialchars($description); ?></textarea>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary"><?php echo $id ? 'Update' : 'Submit'; ?></button>
            </form>
        </div>
    </div>
</main>

<?php include '../include/footer.php'; ?>