<?php
include '../include/header.php';
include '../include/side_bar.php';

// Delete record
if (isset($_GET['delete_id'])) {
    $id = intval($_GET['delete_id']);
    $res = mysqli_query($conn, "SELECT image FROM logo_slider WHERE id='$id'");
    if ($row = mysqli_fetch_assoc($res)) {
        $file = '../uploads/' . $row['image'];
        if (file_exists($file)) {
            unlink($file);
        }
    }
    mysqli_query($conn, "DELETE FROM logo_slider WHERE id='$id'");
    echo "<script>alert('Deleted successfully'); window.location.href='add-client.php';</script>";
    exit;
}

// Insert logos
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit'])) {
    foreach ($_FILES['image']['name'] as $key => $name) {
        if (!empty($name)) {
            $tmp_name = $_FILES['image']['tmp_name'][$key];
            $filename = time() . '_' . basename($name);
            $target = '../uploads/' . $filename;

            if (move_uploaded_file($tmp_name, $target)) {
                mysqli_query($conn, "INSERT INTO logo_slider (image, date) VALUES ('$filename', NOW())");
            }
        }
    }

    echo "<script>alert('Logos uploaded successfully'); window.location.href='add-client.php';</script>";
    exit;
}

// Update logo
if (isset($_POST['update_id'])) {
    $id = intval($_POST['update_id']);
    $queryPart = "";

    if (!empty($_FILES['image']['name'])) {
        $filename = time() . '_' . basename($_FILES['image']['name']);
        $target = '../uploads/' . $filename;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $target)) {
            // Delete old image
            $res = mysqli_query($conn, "SELECT image FROM logo_slider WHERE id='$id'");
            if ($row = mysqli_fetch_assoc($res)) {
                $file = '../uploads/' . $row['image'];
                if (file_exists($file)) {
                    unlink($file);
                }
            }
            $queryPart = ", image='$filename'";
        }
    }

    mysqli_query($conn, "UPDATE logo_slider SET date=NOW() $queryPart WHERE id='$id'");

    if (mysqli_affected_rows($conn) > 0) {
        echo "<script>alert('Logo updated successfully'); window.location.href='add-client.php';</script>";
    } else {
        echo "<script>alert('No update performed.'); window.location.href='add-client.php';</script>";
    }
    exit;
}
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3>Add Logo</h3>
        </div>

        <!-- Add Form -->
        <form method="post" enctype="multipart/form-data">
            <div id="logo-items">
                <div class="row logo-item mb-3">
                    <div class="col-md-10">
                        <input type="file" name="image[]" class="form-control" required>
                    </div>
                    <div class="col-md-2">
                        <button type="button" class="btn btn-danger remove-item">Remove</button>
                    </div>
                </div>
            </div>

            <button type="button" class="btn btn-secondary" id="add-more">Add More</button>
            <button type="submit" name="submit" class="btn btn-primary">Upload Logo</button>
        </form>

        <hr>

        <!-- View List -->
        <h4>Logo List</h4>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Logo</th>
                    <th>Date</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $res = mysqli_query($conn, "SELECT * FROM logo_slider ORDER BY id DESC");
                while ($row = mysqli_fetch_assoc($res)): ?>
                    <tr>
                        <form method="post" enctype="multipart/form-data">
                            <input type="hidden" name="update_id" value="<?php echo $row['id']; ?>">
                            <td><?php echo $row['id']; ?></td>
                            <td>
                                <img src="../uploads/<?php echo $row['image']; ?>" width="60"><br>
                                <input type="file" name="image" class="form-control mt-1">
                            </td>
                            <td><?php echo $row['date']; ?></td>
                            <td>
                                <button type="submit" class="btn btn-success btn-sm mb-1">Update</button>
                                <a href="?delete_id=<?php echo $row['id']; ?>" class="btn btn-danger btn-sm"
                                    onclick="return confirm('Delete this logo?')">Delete</a>
                            </td>
                        </form>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</main>

<script>
    document.getElementById('add-more').addEventListener('click', function () {
        const wrapper = document.getElementById('logo-items');
        const item = document.createElement('div');
        item.className = 'row logo-item mb-3';
        item.innerHTML = `
            <div class="col-md-10">
                <input type="file" name="image[]" class="form-control" required>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-danger remove-item">Remove</button>
            </div>
        `;
        wrapper.appendChild(item);
    });

    document.addEventListener('click', function (e) {
        if (e.target.classList.contains('remove-item')) {
            e.target.closest('.logo-item').remove();
        }
    });
</script>

<?php include '../include/footer.php'; ?>