<style>
    .error-msg {
        color: red;
        padding-bottom: 1rem;
    }
</style>

<?php
include '../include/header.php';
include '../include/side_bar.php';
include '../include/function.inc.php';

$id = "";
$categories = "";
$slug = "";
$short_desc = "";
$old_image = "";
$msg = "";

// Slug Generator Function
function generateSlug($string)
{
    $slug = strtolower(trim($string));
    $slug = preg_replace('/[^a-z0-9-]/', '-', $slug);
    $slug = preg_replace('/-+/', '-', $slug);
    return rtrim($slug, '-');
}

// Fetch data for update
if (isset($_GET['id']) && !empty($_GET['id'])) {
    $id = mysqli_real_escape_string($conn, $_GET['id']);
    $sql = "SELECT * FROM `categories` WHERE id = '$id'";
    $result = mysqli_query($conn, $sql);

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $categories = $row['categories'];
        $slug = $row['slug'];
        $short_desc = $row['short_desc'];
        $old_image = $row['image']; // stored path of image
    } else {
        echo "<script>window.location.href = 'view-categories.php';</script>";
        exit;
    }
}

// Insert / Update
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['submit'])) {
    $id = mysqli_real_escape_string($conn, $_POST['id']);
    $categories = mysqli_real_escape_string($conn, $_POST['categories']);
    $short_desc = mysqli_real_escape_string($conn, $_POST['short_desc']);
    $slug = generateSlug($categories);

    $image_name = $old_image;
    $upload_dir = "../uploads/";

    // Handle image upload
    if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != '') {
        $img_name = $_FILES['image']['name'];
        $tmp_name = $_FILES['image']['tmp_name'];
        $ext = strtolower(pathinfo($img_name, PATHINFO_EXTENSION));
        $allowed_ext = ['jpg', 'jpeg', 'png', 'gif', 'webp'];

        if (in_array($ext, $allowed_ext)) {
            $new_name = "cat_" . time() . "." . $ext;
            $dest_path = $upload_dir . $new_name;

            if (move_uploaded_file($tmp_name, $dest_path)) {
                // delete old image if exists
                if (!empty($old_image) && file_exists($old_image)) {
                    unlink($old_image);
                }
                $image_name = $dest_path;
            } else {
                $msg = "Failed to upload image.";
            }
        } else {
            $msg = "Invalid image type. Only jpg, jpeg, png, gif, webp allowed.";
        }
    }

    if (empty($msg)) {
        // Duplicate check
        $check_sql = "SELECT id FROM `categories` WHERE categories = '$categories' AND id != '$id'";
        $check_result = mysqli_query($conn, $check_sql);

        if ($check_result && mysqli_num_rows($check_result) > 0) {
            $msg = "Category already exists";
        } else {
            if (!empty($id)) {
                // Update
                $sql = "UPDATE `categories` 
                        SET `categories`='$categories',
                            `slug`='$slug',
                            `short_desc`='$short_desc',
                            `image`='$image_name'
                        WHERE `id`='$id'";
                $action = "updated";
            } else {
                // Insert
                $sql = "INSERT INTO `categories` (`categories`, `slug`, `short_desc`, `icon`) 
                        VALUES ('$categories', '$slug', '$short_desc', '$image_name')";
                $action = "inserted";
            }

            if (mysqli_query($conn, $sql)) {
                echo "<script>alert('Record $action successfully!'); window.location.href = 'view-categories.php';</script>";
                exit;
            } else {
                $msg = "Error: " . mysqli_error($conn);
            }
        }
    }
}
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3><?php echo $id ? 'Edit' : 'Add'; ?> Categories</h3>
            <div class="dashboard_heading__right">
                <a href="/">Home</a> <span>/</span>
                <p>Categories</p>
            </div>
        </div>

        <div class="category_wrapper">
            <form action="" method="post" enctype="multipart/form-data">
                <input type="hidden" name="id" value="<?php echo htmlspecialchars($id); ?>">

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Category Name</label>
                            <input type="text" class="form-control" name="categories"
                                value="<?php echo htmlspecialchars($categories); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Category Image</label>
                            <input type="file" class="form-control" name="image" <?php echo $id ? '' : 'required'; ?>>
                            <?php if (!empty($old_image)) { ?>
                                <div style="margin-top:10px;">
                                    <img src="<?php echo htmlspecialchars($old_image); ?>" alt="Category Image" width="120">
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="mb-3">
                            <label class="form-label">Short Description</label>
                            <textarea class="form-control" name="short_desc" rows="3"
                                required><?php echo htmlspecialchars($short_desc); ?></textarea>
                        </div>
                    </div>
                </div>
                <div class="error-msg"><?php echo $msg; ?></div>

                <button type="submit" name="submit" class="btn btn-primary">
                    <?php echo $id ? 'Update' : 'Submit'; ?>
                </button>
            </form>
        </div>
    </div>
</main>

<?php include '../include/footer.php'; ?>